<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "//www.w3.org/TR/html4/strict.dtd">
<html lang="en">
<head>
    <meta http-equiv="Content-Type" content="text/html;charset=UTF-8">
    <title> Sale return report pdf</title>
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('images/favicon.ico')); ?>">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <!-- Fonts -->
    <!-- General CSS Files -->
    <link href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/>
</head>
<body>
<table width="100%" cellspacing="0" cellpadding="10" style="margin-top: 40px;">
    <thead>
    <tr style="background-color: dodgerblue;">
        <th style="width: 200%"><?php echo e(__('messages.pdf.reference')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.supplier')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.warehouse')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.total')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.paid')); ?></th>
        <th style="width: 200%"><?php echo e(__('messages.pdf.due')); ?></th>
        <th style="width: 300%"><?php echo e(__('messages.pdf.payment_status')); ?></th>
    </tr>
    </thead>
    <tbody>
    <?php $__currentLoopData = $saleReturns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $saleReturn): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr align="center">
            <td><?php echo e($saleReturn->reference_code); ?></td>
            <td><?php echo e($saleReturn->customer->name); ?></td>
            <td><?php echo e($saleReturn->warehouse->name); ?></td>
            <td style="float: left"><?php echo e(number_format($saleReturn->grand_total,2)); ?></td>
            <td><?php echo e(number_format((float)$saleReturn->paid_amount, 2)); ?></td>
            <td><?php echo e(number_format((float)$saleReturn->due_amount, 2)); ?></td>
            <?php if($saleReturn->status == \App\Models\SaleReturn::RECEIVED): ?>
                <td>Received</td>
            <?php elseif($saleReturn->status == \App\Models\Sale::PENDING): ?>
                <td>pending</td>
            <?php endif; ?>
        </tr>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
</body>
</html>
<?php /**PATH C:\xampp\htdocs\pos\resources\views/excel/sale-return-report-excel.blade.php ENDPATH**/ ?>